<?php
// Mulai session
session_start();

// Fungsi untuk mendapatkan path koneksi yang benar
function getKoneksiPath() {
    $paths = [
        __DIR__ . '/koneksi.php',
        __DIR__ . '/../koneksi.php',
        './koneksi.php',
        '../koneksi.php'
    ];
    
    foreach ($paths as $path) {
        if (file_exists($path)) {
            return $path;
        }
    }
    return null;
}

// Coba include koneksi.php
$koneksiPath = getKoneksiPath();
if ($koneksiPath && file_exists($koneksiPath)) {
    include $koneksiPath;
} else {
    // Jika koneksi.php tidak ada, buat koneksi langsung
    $host = 'localhost';
    $user = 'root';
    $pass = '';
    $db   = 'db_bukutamu';
    
    $koneksi = mysqli_connect($host, $user, $pass, $db);
    
    if (!$koneksi) {
        // Tampilkan error page jika koneksi gagal
        ?>
        <!DOCTYPE html>
        <html lang="id">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>Koneksi Gagal - Buku Tamu</title>
            <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
            <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
            <style>
                body {
                    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
                    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                    min-height: 100vh;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    padding: 20px;
                }
                .error-box {
                    background: white;
                    border-radius: 20px;
                    padding: 40px;
                    max-width: 600px;
                    width: 100%;
                    box-shadow: 0 20px 60px rgba(0,0,0,0.3);
                    text-align: center;
                }
                .error-icon {
                    font-size: 80px;
                    color: #ef4444;
                    margin-bottom: 20px;
                }
                .error-title {
                    color: #1f2937;
                    font-size: 28px;
                    font-weight: 700;
                    margin-bottom: 15px;
                }
                .error-message {
                    color: #6b7280;
                    font-size: 16px;
                    line-height: 1.6;
                    margin-bottom: 30px;
                }
                .btn-home {
                    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                    color: white;
                    padding: 12px 30px;
                    border-radius: 10px;
                    text-decoration: none;
                    display: inline-block;
                    font-weight: 600;
                    transition: transform 0.3s;
                }
                .btn-home:hover {
                    transform: translateY(-2px);
                    color: white;
                }
            </style>
        </head>
        <body>
            <div class="error-box">
                <div class="error-icon">
                    <i class="fas fa-database"></i>
                </div>
                <h1 class="error-title">Koneksi Database Gagal</h1>
                <p class="error-message">
                    Tidak dapat terhubung ke database. Pastikan:<br>
                    1. XAMPP/MySQL sudah berjalan<br>
                    2. Database <strong>db_bukutamu</strong> sudah dibuat<br>
                    3. File <strong>koneksi.php</strong> ada di folder yang benar
                </p>
                <a href="index.php" class="btn-home">
                    <i class="fas fa-home me-2"></i>Kembali ke Beranda
                </a>
            </div>
        </body>
        </html>
        <?php
        exit();
    }
}

// Inisialisasi variabel
$status = "";
$pesan = "";
$icon = "";
$data = [];
$ticket_id = "";
$theme_gradient = "";

// Proses form submission
if (isset($_POST['kirim'])) {
    // Ambil dan sanitasi data
    $nama = htmlspecialchars(trim($_POST['nama']));
    $email = filter_var(trim($_POST['email']), FILTER_SANITIZE_EMAIL);
    $no_hp = htmlspecialchars(trim($_POST['no_hp']));
    $instansi = htmlspecialchars(trim($_POST['instansi']));
    $keperluan = htmlspecialchars(trim($_POST['keperluan']));
    
    // Validasi
    if (empty($nama) || empty($email) || empty($no_hp) || empty($keperluan)) {
        $status = "error";
        $pesan = "Mohon lengkapi semua field yang wajib diisi!";
        $icon = "fa-exclamation-triangle";
        $theme_gradient = "linear-gradient(135deg, #ef4444 0%, #dc2626 100%)";
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $status = "error";
        $pesan = "Format email tidak valid!";
        $icon = "fa-envelope-open-text";
        $theme_gradient = "linear-gradient(135deg, #ef4444 0%, #dc2626 100%)";
    } else {
        // Insert ke database
        $stmt = $koneksi->prepare("INSERT INTO tamu (nama_lengkap, email, no_hp, instansi, keperluan) VALUES (?, ?, ?, ?, ?)");
        
        if ($stmt) {
            $stmt->bind_param("sssss", $nama, $email, $no_hp, $instansi, $keperluan);
            
            if ($stmt->execute()) {
                $status = "success";
                $pesan = "Terima kasih! Data kunjungan Anda berhasil disimpan.";
                $icon = "fa-check-circle";
                $theme_gradient = "linear-gradient(135deg, #10b981 0%, #059669 100%)";
                $ticket_id = "GTK-" . date('Ymd') . "-" . strtoupper(substr(md5(uniqid()), 0, 6));
                
                $data = [
                    'nama' => $nama,
                    'email' => $email,
                    'no_hp' => $no_hp,
                    'instansi' => $instansi,
                    'keperluan' => $keperluan,
                    'waktu' => date('d F Y, H:i:s')
                ];
            } else {
                $status = "error";
                $pesan = "Gagal menyimpan data: " . $stmt->error;
                $icon = "fa-times-circle";
                $theme_gradient = "linear-gradient(135deg, #ef4444 0%, #dc2626 100%)";
            }
            $stmt->close();
        } else {
            $status = "error";
            $pesan = "Gagal mempersiapkan query database.";
            $icon = "fa-database";
            $theme_gradient = "linear-gradient(135deg, #ef4444 0%, #dc2626 100%)";
        }
    }
} else {
    // Redirect jika akses langsung
    header("Location: index.php");
    exit();
}

// Tutup koneksi
if (isset($koneksi)) {
    mysqli_close($koneksi);
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $status === 'success' ? 'Berhasil' : 'Gagal'; ?> - Buku Tamu</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #6366f1;
            --success: #10b981;
            --error: #ef4444;
        }
        body {
            font-family: 'Inter', sans-serif;
            background: #f3f4f6;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
            margin: 0;
        }
        .confirmation-card {
            background: white;
            border-radius: 24px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.1);
            max-width: 650px;
            width: 100%;
            overflow: hidden;
            animation: fadeInUp 0.6s ease-out;
        }
        @keyframes fadeInUp {
            from { opacity: 0; transform: translateY(30px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .card-header {
            padding: 3rem 2rem;
            text-align: center;
            background: <?php echo $theme_gradient; ?>;
            color: white;
        }
        .icon-wrapper {
            width: 90px;
            height: 90px;
            background: rgba(255,255,255,0.25);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1.5rem;
            animation: pulse 2s infinite;
        }
        @keyframes pulse {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.05); }
        }
        .icon-wrapper i { font-size: 2.5rem; }
        .card-body { padding: 2rem; }
        .data-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1rem;
            margin: 1.5rem 0;
        }
        .data-item {
            background: #f9fafb;
            padding: 1rem;
            border-radius: 12px;
            border: 1px solid rgba(0,0,0,0.04);
        }
        .data-label {
            font-size: 0.75rem;
            color: #6b7280;
            font-weight: 600;
            text-transform: uppercase;
            margin-bottom: 0.5rem;
        }
        .data-value {
            font-size: 0.95rem;
            color: #1f2937;
            font-weight: 500;
        }
        .btn-custom {
            padding: 0.875rem 1.5rem;
            border-radius: 12px;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            transition: all 0.3s;
            border: none;
            cursor: pointer;
        }
        .btn-primary {
            background: linear-gradient(135deg, #6366f1 0%, #4f46e5 100%);
            color: white;
        }
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(99,102,241,0.4);
            color: white;
        }
        .btn-secondary {
            background: white;
            color: #6366f1;
            border: 2px solid #6366f1;
        }
        .btn-secondary:hover {
            background: #6366f1;
            color: white;
        }
        .button-group {
            display: flex;
            gap: 1rem;
            flex-wrap: wrap;
            margin-top: 1.5rem;
        }
        @media (max-width: 576px) {
            .card-header { padding: 2rem 1.5rem; }
            .card-body { padding: 1.5rem; }
            .button-group { flex-direction: column; }
            .btn-custom { width: 100%; justify-content: center; }
        }
    </style>
</head>
<body>

<div class="confirmation-card">
    <div class="card-header">
        <div class="icon-wrapper">
            <i class="fas <?php echo $icon; ?>"></i>
        </div>
        <h1 class="h2 mb-2"><?php echo $status === 'success' ? 'Berhasil!' : 'Gagal!'; ?></h1>
        <p class="mb-0"><?php echo $pesan; ?></p>
        <?php if($status === 'success' && $ticket_id): ?>
            <div class="mt-3" style="background: rgba(255,255,255,0.25); padding: 0.5rem 1.25rem; border-radius: 50px; display: inline-block;">
                <i class="fas fa-ticket-alt me-2"></i>
                <strong><?php echo $ticket_id; ?></strong>
            </div>
        <?php endif; ?>
    </div>
    
    <div class="card-body">
        <?php if($status === 'success' && !empty($data)): ?>
            <h5 class="mb-3"><i class="fas fa-clipboard-list text-primary me-2"></i>Ringkasan Data</h5>
            <div class="data-grid">
                <div class="data-item">
                    <div class="data-label"><i class="fas fa-user me-2"></i>Nama</div>
                    <div class="data-value"><?php echo $data['nama']; ?></div>
                </div>
                <div class="data-item">
                    <div class="data-label"><i class="fas fa-envelope me-2"></i>Email</div>
                    <div class="data-value"><?php echo $data['email']; ?></div>
                </div>
                <div class="data-item">
                    <div class="data-label"><i class="fas fa-phone me-2"></i>No. HP</div>
                    <div class="data-value"><?php echo $data['no_hp']; ?></div>
                </div>
                <div class="data-item">
                    <div class="data-label"><i class="fas fa-building me-2"></i>Instansi</div>
                    <div class="data-value"><?php echo $data['instansi'] ?: '-'; ?></div>
                </div>
                <div class="data-item" style="grid-column: 1 / -1;">
                    <div class="data-label"><i class="fas fa-comment me-2"></i>Keperluan</div>
                    <div class="data-value"><?php echo $data['keperluan']; ?></div>
                </div>
                <div class="data-item">
                    <div class="data-label"><i class="fas fa-clock me-2"></i>Waktu</div>
                    <div class="data-value"><?php echo $data['waktu']; ?></div>
                </div>
            </div>
            
            <div class="alert alert-info border-0" style="background: #eff6ff; border-radius: 12px;">
                <i class="fas fa-info-circle me-2"></i>
                <small>Simpan halaman ini sebagai bukti kunjungan Anda.</small>
            </div>
        <?php endif; ?>
        
        <div class="button-group">
            <a href="index.php" class="btn-custom btn-primary">
                <i class="fas fa-home"></i> Kembali ke Beranda
            </a>
            <a href="admin.php" class="btn-custom btn-secondary">
                <i class="fas fa-users-cog"></i> Halaman Admin
            </a>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<?php if($status === 'success'): ?>
<script>
    setTimeout(() => {
        window.location.href = 'index.php';
    }, 30000);
</script>
<?php endif; ?>

</body>
</html>