<?php
/**
 * Database Connection Configuration
 * 
 * PENTING UNTUK PRODUCTION:
 * 1. Jangan upload file ini ke repository publik (GitHub/GitLab) tanpa proteksi.
 * 2. Sebaiknya gunakan .env file untuk menyimpan kredensial database.
 * 3. Pastikan user database memiliki hak akses terbatas (least privilege).
 */

// Konfigurasi Database
define('DB_HOST', 'localhost');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_NAME', 'db_bukutamu');
define('DB_CHARSET', 'utf8mb4');

// Membuat Koneksi
$koneksi = mysqli_connect(DB_HOST, DB_USER, DB_PASS, DB_NAME);

// Cek Koneksi
if (!$koneksi) {
    // Jika koneksi gagal, tampilkan halaman error profesional
    // Alih-alih menampilkan error PHP mentah
    $error_message = "Koneksi Database Gagal: " . mysqli_connect_error();
    $error_code = mysqli_connect_errno();
    
    // Output HTML Error Page
    ?>
    <!DOCTYPE html>
    <html lang="id">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>System Maintenance - Buku Tamu</title>
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
        <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
        <style>
            body {
                font-family: 'Inter', sans-serif;
                background: #f3f4f6;
                background-image: radial-gradient(at 0% 0%, rgba(99, 102, 241, 0.1) 0px, transparent 50%),
                                radial-gradient(at 100% 100%, rgba(239, 68, 68, 0.1) 0px, transparent 50%);
                min-height: 100vh;
                display: flex;
                align-items: center;
                justify-content: center;
                padding: 20px;
                margin: 0;
            }
            .error-card {
                background: white;
                border-radius: 24px;
                box-shadow: 0 20px 60px rgba(0, 0, 0, 0.1);
                max-width: 500px;
                width: 100%;
                overflow: hidden;
                animation: fadeInUp 0.6s ease-out;
            }
            @keyframes fadeInUp {
                from { opacity: 0; transform: translateY(30px); }
                to { opacity: 1; transform: translateY(0); }
            }
            .error-header {
                background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
                padding: 3rem 2rem;
                text-align: center;
                color: white;
            }
            .error-icon {
                width: 80px;
                height: 80px;
                background: rgba(255, 255, 255, 0.2);
                border-radius: 50%;
                display: flex;
                align-items: center;
                justify-content: center;
                margin: 0 auto 1rem;
                animation: pulse 2s infinite;
            }
            @keyframes pulse {
                0%, 100% { transform: scale(1); }
                50% { transform: scale(1.1); }
            }
            .error-icon i { font-size: 2.5rem; }
            .error-body { padding: 2rem; text-align: center; }
            .error-title { font-size: 1.5rem; font-weight: 700; color: #1f2937; margin-bottom: 1rem; }
            .error-desc { color: #6b7280; margin-bottom: 1.5rem; line-height: 1.6; }
            .error-tech { 
                background: #f9fafb; 
                border: 1px solid #e5e7eb; 
                border-radius: 8px; 
                padding: 1rem; 
                font-family: monospace; 
                font-size: 0.85rem; 
                color: #ef4444;
                text-align: left;
                margin-bottom: 1.5rem;
                word-break: break-all;
            }
            .btn-retry {
                background: linear-gradient(135deg, #6366f1 0%, #4f46e5 100%);
                color: white;
                border: none;
                padding: 0.75rem 2rem;
                border-radius: 12px;
                font-weight: 600;
                text-decoration: none;
                display: inline-block;
                transition: all 0.3s;
            }
            .btn-retry:hover {
                transform: translateY(-2px);
                box-shadow: 0 8px 20px rgba(99, 102, 241, 0.3);
                color: white;
            }
            .contact-support {
                margin-top: 1.5rem;
                font-size: 0.875rem;
                color: #6b7280;
            }
            .contact-support i { color: #6366f1; margin-right: 0.5rem; }
        </style>
    </head>
    <body>
        <div class="error-card">
            <div class="error-header">
                <div class="error-icon">
                    <i class="fas fa-database"></i>
                </div>
                <h2 class="mb-0">System Maintenance</h2>
            </div>
            <div class="error-body">
                <h3 class="error-title">Koneksi Database Terputus</h3>
                <p class="error-desc">
                    Maaf, sistem sedang mengalami gangguan koneksi ke database. 
                    Tim teknis kami telah diberitahu dan sedang bekerja untuk memperbaikinya.
                </p>
                
                <?php if(isset($error_message)): ?>
                <div class="error-tech">
                    <strong>Error Code:</strong> <?php echo $error_code; ?><br>
                    <strong>Message:</strong> <?php echo htmlspecialchars($error_message); ?>
                </div>
                <?php endif; ?>
                
                <a href="index.php" class="btn-retry">
                    <i class="fas fa-sync-alt me-2"></i>Coba Lagi
                </a>
                
                <div class="contact-support">
                    <p class="mb-0">
                        <i class="fas fa-headset"></i>
                        Butuh bantuan? Hubungi Administrator
                    </p>
                </div>
            </div>
        </div>
    </body>
    </html>
    <?php
    // Hentikan eksekusi script karena database tidak terhubung
    exit();
}

// Jika berhasil, set charset untuk mendukung karakter khusus (emoji, dll)
mysqli_set_charset($koneksi, DB_CHARSET);

// Opsi: Mencegah akses langsung ke file ini (Security Best Practice)
// if (basename($_SERVER['PHP_SELF']) === 'koneksi.php') {
//     header('Location: index.php');
//     exit();
// }
?>